--mme si 2me position
-- crire from en premier
select FirstName
From DimCustomER

-- je veux afficher toutes les colonnes
-- de la table geography
-- 655 : nombre de lignes
select *
from DimGeography

-- pareil mais limiter le nb de lignes 100
select top 100 *
from DimGeography

-- afficher les 75 premires lignes
-- et la colonne ipaddresslocation
select top 75 IpAddressLocator
from DimGeography

-- je veux afficher stateprovincename en plus
select top 75 IpAddressLocator, 
			  StateProvinceName
from DimGeography

-- Je veux afficher les pays
-- afficher colonne : toutes les lignes
-- afficher chaque valeur distinctement
-- supprimer les doublons : select distinct col
select distinct FrenchCountryRegionName
From DimGeography

-- afficher les pays et les villes diffrentes
-- suppression doublons sur pays et ville en mme temps
select distinct FrenchCountryRegionName, city
From DimGeography

-- Renommer les colonnes
-- le as n'est pas obligatoire --> un bloc
-- mettre cotes tout le temps : rouge
-- un seul mot : pas besoin de cotes ou guillements
-- plusieurs mots (pas un bloc car espaces) : cotes ou guillements
-- si apostrophe : mettre double cote
select distinct FrenchCountryRegionName as pays, -- 'pays'
				city as 'ville du pays',
				IpAddressLocator as 'l''adresse'
From DimGeography

-- on renomme pour que a soit propre mais galement
-- quand on utilise des Fonctions intgres
-- rose : fonction(colonne)
-- ANNEE : year() : piocher l'anne dans une date
Select LastName, FirstName,
		year(BirthDate)	as 'anne de naissance'
From DimCustomer

-- Afficher les pays, les villes et les IPadresslocator
-- mais trier par ordre alphabtique/asc des pays
-- et par ordre desc des ville
select FrenchCountryRegionName as pays, -- 'pays'
				city as 'ville du pays',
				IpAddressLocator as 'l''adresse'
From DimGeography
order by FrenchCountryRegionName, city desc
-- order by pays -- asc est par dfaut

-- trier par pays asc
-- utiliser le renommage mais uniquement ici

---------------------------------------------
--1. SELECT col1 , col2 as 'ville pays'
---2. FROM Table (provenance)
----3. WHERE col = 'val' AND/(OR) Conditions/filtres BD
-------6. ORDER BY col1, col2 Trier

-- exactement identique/diffrent  1 seule valeur
-- les lignes pour lesquelles j'ai la france
-- mais pas les parisiens
Select *
From DimGeography
where FrenchCountryRegionName = 'France'
and city <> 'paris'

-- exactement identique/diffrent  PLUSIEURS valeurs
-- France et les ETATS UNIS
-- mais pas paris ni miami ni paris la defense
Select *
From DimGeography
where FrenchCountryRegionName IN ('France', 'tats-Unis')
and city NOT IN ('paris','paris la defense', 'miami')
-- contient/ne contient pas db, fin, milieu, etc
-- Les pays dont le nom commence par A
-- stateprovincename ne contient pas south
Select *
From DimGeography
where FrenchCountryRegionName LIKE 'a%'
and StateProvinceName not like '%south%'
-- like : contient
-- a : au dbut a
-- % qu'importe ce qu'il y a aprs

-- les pays qui commencent par A ou par C
-- contourner le problme pour utiliser le IN
-- FI texte qui va aller chercher la premire lettre  gche
Select distinct FrenchCountryRegionName,
		left(FrenchCountryRegionName,1) as '1re lettre'
From DimGeography
where left(FrenchCountryRegionName,1) IN ('A','C')
-- quand la premire lettre du pays est A ou C

-- where (FrenchCountryRegionName LIKE 'a%'
	-- OR FrenchCountryRegionName LIKE 'c%') AND col =2

-- afficher uniqument les geokey entre 170 et 176
Select *
From DimGeography
where left(FrenchCountryRegionName,1) IN ('A','C')
and GeographyKey between 170 and 176 -- deb et fin incluses
-- GeographyKey >= 170 and GeographyKey <= 170 
-- 3* + de performance
-- dcimales, dates, chane de caractres (n'inclut pas la lettre finale)

-- Gestion des null -- is null/ is not null
-- quand middlename est non renseigne (pas second prnom)
-- quand le enddate est renseigne (parti de l'entreprise)
-- ge employe quand elle est partie de l'entreprise
-- combien d'annes qu'elle est partie ?
Select lastname, firstname,
		datediff(YEAR, BirthDate, EndDate) as 'ge dpart',
		datediff(year, EndDate, getdate() )as 'nb annes dep dp'
-- datediff(annes/mois/jours:unit mesure, date dbut, date fin)
From DimEmployee
where MiddleName is null
and EndDate is not null

----------------------------------------------------------
-----------------GROUP BY--------------------
--1. SELECT col1 , col2 as 'ville pays'
---2. FROM Table (provenance)
----3. WHERE col = 'val' AND/(OR) Conditions/filtres BD
-----4. GROUP BY colonnes (car calcul PAR/regroup)
-------6. ORDER BY col1, col2 Trier

-- Fonction intgre d'agrgation -- fonction d'agrgations : calculs sur plusieurs lignes
-- sum, count, max, avg (moyenne), min, max

-- compter le nombre d'employs -- PK/FK
Select count(EmployeeKey) as 'nombre d''employs'
From DimEmployee

-- F.2. compter le nombre d'employs
-- par dpartement et par title
Select DepartmentName, title , 
	  count(EmployeeKey) as 'nombre d''employs'
From DimEmployee
Group by DepartmentName, title

-- 0 : calcul : count
--1re tape GROUP BY : PAR : j'cris group by
--2me tape : copier/coller contenu group by -- select

-- F.1. Compter le nombre de villes PAR pays
Select FrenchCountryRegionName, count(city) as 'nombre de villes'
From DimGeography
Group by FrenchCountryRegionName

------------------------- HAVING ---------------
--1. SELECT col1 , col2 as 'ville pays'
---2. FROM Table (provenance)
----3. WHERE col = 'val' AND/(OR) Conditions/filtres BD
-----4. GROUP BY colonnes (car calcul PAR/regroup)
------5. HAVING count(col) > 50 Condition/Filtres FA
-------6. ORDER BY col1, col2 Trier

-- F.1. Compter le nombre de villes PAR pays
-- quand le geographykey est entre 50 et 500 -- pas FA
-- quand le nombre de villes est suprieur  60 -- FA
-- trier par nombre de villes desc
Select FrenchCountryRegionName, 
	   count(city) as 'nombre de villes'
From DimGeography
where GeographyKey between 50 and 500
Group by FrenchCountryRegionName
having count(city) > 60
order by [nombre de villes] desc

-- F.2. compter le nombre d'employs
-- par dpartement et par title
-- quand l'employ est n  partir de 1980 -- pas FA
-- quand le dep/title  plus de 10 employes - FA
Select DepartmentName, title , 
	  count(EmployeeKey) as 'nombre d''employs'
From DimEmployee
where year(BirthDate) >= 1980
Group by DepartmentName, title
having count(EmployeeKey) > 10
order by [nombre d'employs] desc

-- unitsbalance moyenne, unitcost max
-- par anne, trimestre et par mois
-- trier sur l'anne et le mois asc
-- quand le mois est entre le 3 et le 12
-- quand le cot max  l'unit est suprieur ou gal  1000
Select year(MovementDate) as anne, 
		datepart(quarter, movementdate) as trimestre, 
		month(MovementDate) as mois,
		avg(UnitsBalance) as 'unitbalance moyen',
		max(UnitCost) as 'unitcost max'
From FactProductInventory
where month(MovementDate) between 3 and 12
Group by year(MovementDate), datepart(quarter, movementdate), month(MovementDate)
having max(UnitCost) > 1000
order by anne, mois

-- compter le nombre de lignes
-- compter le nombre de produits
-- compter le nombre de propuits qui n'ont pas de taille 
-- count(colonne) : les valeurs renseignes
-- compter le nombre de couleurs
Select count(*) as 'nombre de lignes/produits',
	   count(productkey) as 'nombre de produits',
	   count(size) as 'nb prod avec taille renseigne',
	   count(distinct color) as 'nb couleurs diffrentes'
From dimproduct

-------------------------------------------------------------------------
------------------------JOINTURES INTERNES ----------------------------------
 -- Nom des revendeurs qui ont ralis au moins une vente
 -- 1re question : factresellersales et dimreseller -- tables
 -- 2me question : cl resellerkey -- cl ?

 -- Points de vigilance : 
 -- jointure : cre une norme table de correspondance : doublons
 -- trs important : DISTINCT (si moins=doublons, ncessaire)
 -- NOM (personnes, produits, etc.) : plusieurs DUPONT, l'id tjs
 -- sinon il supprime doublons sur des noms qui ne fallait pas
 Select distinct ResellerName, DimReseller.ResellerKey
 From DimReseller JOIN FactResellerSales
	ON DimReseller.ResellerKey = FactResellerSales.ResellerKey
-- dans la table dimreseller le champ reskey est gal a reskey de la table factresellersales

--join : filtrer les revendeurs que s'ils sont dans les 2 tables
-- jointures : d'aller rcuprer d'autres colonnes
-- mais c'est bas sur une correspondance : corr parfaite (supprimer des lignes)

-- rcuprer en +, le nom des produits qu'ils ont achet
 Select distinct ResellerName, DimReseller.ResellerKey, EnglishProductName
 From DimReseller JOIN FactResellerSales
	ON DimReseller.ResellerKey = FactResellerSales.ResellerKey
				  JOIN Dimproduct
	ON DimProduct.ProductKey = FactResellerSales.ProductKey
 -- appel des 2 premires tables (schma-nonc) table1 join table2
 -- comment sont-elles relies ? ON table1.cl =table2.cl
 -- appel d'une 3me table (schma) -- dimproduct : productkey
 -- comment sont-elles relies ? ON table3.etc.

 -- + tard : les alias/renommage de table
 -- confort d'criture / lecture
Select distinct ResellerName, r.ResellerKey
From DimReseller as R  JOIN FactResellerSales as V
	ON r.ResellerKey = V.ResellerKey
	
--------------------- JOINTURES EXTERNES ---------------------
--------------------------------------------------------------
-- Tous les revendeurs (avec ou non des ventes) 
-- o sont-ils : dimreseller
 Select distinct ResellerName, DimReseller.ResellerKey
 From DimReseller LEFT JOIN FactResellerSales -- dimreseller est  gauche
 -- From FactResellerSales RIGHT JOIN DimReseller   -- est  droite
	ON DimReseller.ResellerKey = FactResellerSales.ResellerKey

-------------------------------------------
-- Les revendeurs qui n'ont pas fait de ventes
-- jointures externes : left/right
-- condition null sur une colonne obligtoire/cl de l'autre table
 Select distinct ResellerName, DimReseller.ResellerKey, 
		FactResellerSales.*
 From DimReseller LEFT JOIN FactResellerSales -- dimreseller est  gauche
 -- From FactResellerSales RIGHT JOIN DimReseller   -- est  droite
	ON DimReseller.ResellerKey = FactResellerSales.ResellerKey
where FactResellerSales.productkey IS NULL

-----------------------------------------
-- E.13 Je souhaite afficher les lignes clients correspondantes  deux profils diffrents :
-- ceux qui ont seulement le bac (valeur "baccalaurat") (frencheducation) et qui sont  5-10 miles du travail (commutedistance)
-- ainsi que ceux qui sont bac + 4 et qui sont  1-2 miles
-- Rsultat : 1706

Select lastname, FirstName, 'bac et 5-10 miles' as profil
From dimcustomer
where FrenchEducation ='Baccalaurat' and CommuteDistance = '5-10 miles'
			UNION
Select lastname, FirstName, 'bac+4 et 1-2 miles' as ' '
From dimcustomer
where FrenchEducation ='bac + 4' and CommuteDistance = '1-2 miles'

----------------------- 1 seule requte
Select lastname, FirstName
From dimcustomer
where FrenchEducation ='Baccalaurat' and CommuteDistance = '5-10 miles'
		OR
FrenchEducation ='bac + 4' and CommuteDistance = '1-2 miles'


